/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.repo.filter;

import com.tp_link.eap.d.b;
import com.tp_link.eap.domain.account.Role;
import com.tp_link.eap.domain.account.User;
import com.tp_link.eap.domain.cloud.CloudUser;
import com.tp_link.eap.domain.cloud.ModelFw;
import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.hotspot.Operator;
import com.tp_link.eap.domain.scheduler.bean.AutoBackupFile;
import com.tp_link.eap.domain.site.Privilege;
import com.tp_link.eap.domain.site.Site;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryFilter$FilterType;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.domain.ui.QuerySort$SortDirection;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public class FilterRepository<T> {
    @Autowired
    protected MongoTemplate mongoTemplate;
    protected Class<T> entityClass;
    private static List<Class<?>> a = new ArrayList();
    private Logger b = LoggerFactory.getLogger(this.getClass());

    public FilterRepository() {
        this.entityClass = this.getEntityClass();
    }

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    protected Class<T> getEntityClass() {
        Type type = this.getClass().getGenericSuperclass();
        Class clazz = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            clazz = (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return clazz;
    }

    public List<T> getByFilters(QueryPage page, QuerySort sort, List<QueryFilter> andFilters, List<QueryFilter> orFilters) {
        if (andFilters == null) {
            andFilters = new ArrayList<QueryFilter>();
        }
        Query query = this.getFilterQuery(orFilters, andFilters);
        if (sort != null) {
            QuerySort$SortDirection querySort$SortDirection = sort.getSortDirection();
            if (querySort$SortDirection.equals((Object)QuerySort$SortDirection.asc)) {
                query.with(new Sort(Sort.Direction.ASC, sort.getSortKey()));
            } else {
                query.with(new Sort(Sort.Direction.DESC, sort.getSortKey()));
            }
        }
        if (page != null) {
            query.with((Pageable)new PageRequest(page.getPage(), page.getSize()));
        }
        return this.mongoTemplate.find(query, this.entityClass);
    }

    public long countByFilters(List<QueryFilter> andFilters, List<QueryFilter> orFilters) {
        if (andFilters == null) {
            andFilters = new ArrayList<QueryFilter>();
        }
        Query query = this.getFilterQuery(orFilters, andFilters);
        return this.mongoTemplate.count(query, this.entityClass);
    }

    protected Query getFilterQuery(List<QueryFilter> orFilters, List<QueryFilter> andFilters) {
        QueryFilter queryFilter;
        int n;
        Query query = new Query();
        Criteria criteria = new Criteria();
        ArrayList<Criteria> arrayList = new ArrayList<Criteria>();
        ArrayList<Criteria> arrayList2 = new ArrayList<Criteria>();
        if (orFilters != null && !orFilters.isEmpty()) {
            for (n = 0; n < orFilters.size(); ++n) {
                queryFilter = orFilters.get(n);
                if (!queryFilter.getFilterType().equals((Object)QueryFilter$FilterType.like)) {
                    throw new IllegalArgumentException("Search key query type can only be 'like'");
                }
                arrayList.add(Criteria.where((String)queryFilter.getFilterName()).regex((String)queryFilter.getFilterValue()));
            }
        }
        if (andFilters != null && !andFilters.isEmpty()) {
            for (n = 0; n < andFilters.size(); ++n) {
                queryFilter = andFilters.get(n);
                if (queryFilter.getFilterType().equals((Object)QueryFilter$FilterType.eq)) {
                    arrayList2.add(Criteria.where((String)queryFilter.getFilterName()).is(queryFilter.getFilterValue()));
                    continue;
                }
                if (queryFilter.getFilterType().equals((Object)QueryFilter$FilterType.lt)) {
                    arrayList2.add(Criteria.where((String)queryFilter.getFilterName()).lt(queryFilter.getFilterValue()));
                    continue;
                }
                if (queryFilter.getFilterType().equals((Object)QueryFilter$FilterType.lte)) {
                    arrayList2.add(Criteria.where((String)queryFilter.getFilterName()).lte(queryFilter.getFilterValue()));
                    continue;
                }
                if (queryFilter.getFilterType().equals((Object)QueryFilter$FilterType.gt)) {
                    arrayList2.add(Criteria.where((String)queryFilter.getFilterName()).gt(queryFilter.getFilterValue()));
                    continue;
                }
                if (queryFilter.getFilterType().equals((Object)QueryFilter$FilterType.gte)) {
                    arrayList2.add(Criteria.where((String)queryFilter.getFilterName()).gte(queryFilter.getFilterValue()));
                    continue;
                }
                if (queryFilter.getFilterType().equals((Object)QueryFilter$FilterType.like)) {
                    arrayList2.add(Criteria.where((String)queryFilter.getFilterName()).regex((String)queryFilter.getFilterValue()));
                    continue;
                }
                throw new IllegalArgumentException("unsupported filter type.");
            }
        }
        this.a(arrayList2, andFilters);
        if (arrayList.size() > 0) {
            criteria.orOperator(arrayList.toArray(new Criteria[arrayList.size()]));
        }
        if (arrayList2.size() > 0) {
            criteria.andOperator(arrayList2.toArray(new Criteria[arrayList2.size()]));
        }
        if (criteria != null) {
            query.addCriteria(criteria);
        }
        return query;
    }

    private void a(List<Criteria> list, List<QueryFilter> list2) {
        if (this.a(this.entityClass)) {
            String string = com.tp_link.eap.d.b.a();
            if (this.entityClass.isAssignableFrom(Ap.class)) {
                int n = this.a(list2);
                if (n == 0) {
                    this.b.debug("query pending aps, no need to add site filter");
                    list.add(Criteria.where((String)"wirelessLinked").exists(true).orOperator(new Criteria[]{Criteria.where((String)"wirelessLinked").is((Object)false), Criteria.where((String)"wirelessLinked").is((Object)true).and("wirelessPendingSite").all(new Object[]{string})}));
                    return;
                }
                if (n == 1) {
                    this.b.debug("query all aps, add regex filter");
                    list.add(Criteria.where((String)"site").regex(Pattern.compile("PENDING-SITE|" + string)));
                    list.add(Criteria.where((String)"wirelessLinked").exists(true).orOperator(new Criteria[]{Criteria.where((String)"status").ne((Object)2), Criteria.where((String)"status").is((Object)2).orOperator(new Criteria[]{Criteria.where((String)"wirelessLinked").is((Object)false), Criteria.where((String)"wirelessLinked").is((Object)true).and("wirelessPendingSite").all(new Object[]{string})})}));
                    return;
                }
            }
            list.add(Criteria.where((String)"site").is((Object)string));
        } else {
            this.b.debug("no need to add site filter for query " + this.entityClass);
        }
    }

    private int a(List<QueryFilter> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 1;
        }
        for (QueryFilter queryFilter : list) {
            if (!queryFilter.getFilterName().equals("status") || (Integer)queryFilter.getFilterValue() != 2) continue;
            return 0;
        }
        return 2;
    }

    private boolean a(Class<?> clazz) {
        for (Class<?> clazz2 : a) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    static {
        a.add(Site.class);
        a.add(Privilege.class);
        a.add(User.class);
        a.add(Operator.class);
        a.add(Role.class);
        a.add(CloudUser.class);
        a.add(ModelFw.class);
        a.add(AutoBackupFile.class);
    }
}

